<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>

<html>
	<head>
		<title>Widget Catalog</title>
		
		<style type="text/css">
		    .resultTable {
				font: 11px/24px Verdana, Arial, Helvetica, sans-serif;
				border-collapse: collapse;
				width: 320px;	    
		        border-color: #BBB;
		        border-width: 1px;
		        border-style: solid;
		    }
			.resultTable td {
				border-bottom: 1px solid #CCC;
				border-left: 1px solid #CCC;
				border-right: 1px solid #CCC;
				padding: 0 0.5em;
			}		
		
		    .header {
				padding: 0 0.5em;
				text-align: center;	    
		        font-weight: bold;
				border-top: 1px solid #FB7A31;
				border-bottom: 1px solid #FB7A31;
				background: #FFC;	    
		    }	    
		    .oddRow {
			  background-color: white;
		    }
		    .evenRow {
			  background-color: #FFD;
		    }
	    </style>
	 
	</head>
	<body>
		<f:view>
		  <h:form id="catalogForm">
			<h:dataTable value="#{catalogPage.items}" 
			             var="item" 
			             styleClass="resultTable"
			             headerClass="header"
			             rowClasses="oddRow, evenRow"
			             binding="#{catalogPage.selectedRow}"
			             id="table">
			             
				<h:column>
					<f:facet name="header">
					    <h:outputText value="Code"/>
					</f:facet>
					<h:commandLink value="#{item.code}"
					               action="#{catalogPage.displayDetails}"/>				
				</h:column>
				<h:column>
					<f:facet name="header">
						<h:outputText value="Name"/>
					</f:facet>
					<h:outputText value="#{item.name}"/>					
				</h:column>
			</h:dataTable>
		  </h:form>
		</f:view>
	</body>	
</html>  
