package ezprimers.jsf.currencyconverter.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;

import ezprimers.jsf.currencyconverter.business.CurrencyConverter;

public class CurrencyConverterPage implements Serializable {

    private double amount;
    private ConversionResultsPage conversionResultsPage;
    private List currencies = new ArrayList();
    private String selectedCurrency;

    private boolean includeFees;

    public CurrencyConverterPage() {
        currencies.add(new SelectItem("FRF","French Francs",""));
        currencies.add(new SelectItem("FRF","French Francs",""));
    }
    private String[] selectedCurrencies = new String[0];
    public String[] getSelectedCurrencies() {
		return selectedCurrencies;
	}

	public void setSelectedCurrencies(String[] selectedCurrencies) {
		this.selectedCurrencies = selectedCurrencies;
	}

	public double getAmount() {
        return amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }
    
    public ConversionResultsPage getConversionResultsPage() {
        return conversionResultsPage;
    }

    public void setConversionResultsPage(ConversionResultsPage conversionResultsPage) {
        this.conversionResultsPage = conversionResultsPage;
    }
    
    public void setSelectedCurrency(String selectedCurrency) {
        this.selectedCurrency = selectedCurrency;
    }

    public String getSelectedCurrency() {
        return selectedCurrency;
    }
    
    public boolean isIncludeFees() {
		return includeFees;
	}

	public void setIncludeFees(boolean includeFees) {
		this.includeFees = includeFees;
	}

	public String convert() {
        //
        // Convert amount
        //
        CurrencyConverter convertor = CurrencyConverter.getInstance();
        double result = convertor.convertEurosToFRF(amount);       
        //
        // Set values to be displayed in the results page
        //
        ConversionResultsPage resultsPage = getConversionResultsPage();
        resultsPage.setAmount(amount);
        resultsPage.setResult(result);
        resultsPage.setResultCurrency(selectedCurrency);
        
        return "viewResults";
    }
}
