package ezprimers.jsf.currencyconverter.pages;

import java.util.List;

import javax.faces.component.UIData;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

import ezprimers.jsf.currencyconverter.business.Widget;
import ezprimers.jsf.currencyconverter.dao.WidgetsDAO;

public class CatalogPage { 

	private List<Widget> items;

	private DetailsPage detailsPage;
	
	public CatalogPage() {
		super();
		WidgetsDAO dao = new WidgetsDAO();
		setItems(dao.findAll());
	}

	/**
	* Holds value of selectedRow datatable row.
	*/
	private UIData selectedRow;
	
	public UIData getSelectedRow() {
		return selectedRow;
	}

	public void setSelectedRow(UIData selectedRow) {
		this.selectedRow = selectedRow;
	}

	public List<Widget> getItems() {
		return items;
	}

	public void setItems(List<Widget> items) {
		this.items = items;
	}
	

	public DetailsPage getDetailsPage() {
		return detailsPage;
	}

	public void setDetailsPage(DetailsPage detailsPage) {
		this.detailsPage = detailsPage;
	}

	public String displayDetails() {
		Widget selectedWidget = (Widget) getSelectedRow().getRowData();
		getDetailsPage().setWidget(selectedWidget);
		return "displayDetails";
	}
	
}
