package com.wakaleo.jpt.taxcalculator.impl;

import java.util.ArrayList;
import java.util.List;

import org.joda.time.DateTime;

import com.wakaleo.jpt.taxcalculator.InvalidYearException;
import com.wakaleo.jpt.taxcalculator.TaxCalculator;

public class TaxCalculatorImpl implements TaxCalculator {

    public static final List<TaxRate> TAX_RATES = new ArrayList<TaxRate>();

    static {
        TAX_RATES.add(new TaxRate(0, 38000, 0.195));
        TAX_RATES.add(new TaxRate(38000, 60000, 0.33));
        TAX_RATES.add(new TaxRate(60000, 0, 0.39));
    }

    public double calculateIncomeTax(double income, int year)
            throws InvalidYearException {

        DateTime today = new DateTime();

        if (year > today.getYear()) {
            throw new InvalidYearException(
                    "No tax calculations available yet for the year " + year);
        }

        double totalTax = 0.0;
        if (income > 0) {
            for (TaxRate rate : TAX_RATES) {
                totalTax += rate.calculateTax(income);
            }
        }
        return totalTax;
    }

}
