package com.wakaleo.jpt.taxcalculator.impl;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.*;
import static org.junit.Assume.assumeThat;

import org.junit.experimental.theories.DataPoint;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

import com.wakaleo.jpt.taxcalculator.InvalidYearException;
import com.wakaleo.jpt.taxcalculator.TaxCalculator;
import com.wakaleo.jpt.taxcalculator.impl.TaxCalculatorImpl;

@RunWith(Theories.class)
public class TaxCalculationTheoryTest {    

    @DataPoint public static int YEAR_2006 = 2006;
    @DataPoint public static int YEAR_2007 = 2007;
    @DataPoint public static int YEAR_2008 = 2008;
    @DataPoint public static double INCOME_1 = 0;
    @DataPoint public static double INCOME_2 = 1000;
    @DataPoint public static double INCOME_3 = 5000;
    @DataPoint public static double INCOME_4 = 8000;
    @DataPoint public static double INCOME_5 = 15000;
    @DataPoint public static double INCOME_6 = 25000;
    @DataPoint public static double INCOME_7 = 35000;
    @DataPoint public static double INCOME_8 = 37000;
    @DataPoint public static double INCOME_9 = 37999;
    @DataPoint public static double INCOME_10= 38000;
    @DataPoint public static double INCOME_12= 38001;
    @DataPoint public static double INCOME_13= 40000;
    @DataPoint public static double INCOME_14= 50000;
    @DataPoint public static double INCOME_15= 60000;

    
    @Theory
    public void incomeUpTo38000IsTaxedAtLowestRate(double income,int year) throws InvalidYearException {
        assumeThat(year,anyOf(is(2007),is(2008)));
        assumeThat(income,lessThanOrEqualTo(38000.00));
        TaxCalculator calculator = new TaxCalculatorImpl();
        double calculatedTax = calculator.calculateIncomeTax(income, year);
        double expectedTax = income * 0.195;
        System.out.println("year = " + year + ", income=" + income + ", calculated tax=" + calculatedTax);
        assertThat(expectedTax,is(calculatedTax));
    }
}