/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.exporter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.objectlab.qalab.interfaces.QALabExporter;
import net.objectlab.qalab.util.TaskLogger;
import net.objectlab.qalab.util.Util;
import org.apache.tools.ant.BuildException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class QALabXMLExporter
implements QALabExporter {
    private static final String XML_VERSION = "1.1";
    private static final String DTD_DEFINITION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.getProperty("line.separator") + "<!DOCTYPE qalab [" + System.getProperty("line.separator") + "<!ELEMENT qalab (summary, file*)>" + System.getProperty("line.separator") + "<!ATTLIST qalab version CDATA #REQUIRED> " + System.getProperty("line.separator") + "<!ELEMENT summary (summaryresult*)>" + System.getProperty("line.separator") + "<!ELEMENT file (result+)>" + System.getProperty("line.separator") + "<!ATTLIST file id ID #REQUIRED" + System.getProperty("line.separator") + "   path CDATA #REQUIRED>" + System.getProperty("line.separator") + "<!ELEMENT result EMPTY>" + System.getProperty("line.separator") + "<!ATTLIST result date CDATA #REQUIRED" + System.getProperty("line.separator") + "   statvalue CDATA #REQUIRED" + System.getProperty("line.separator") + "   type CDATA #REQUIRED>" + System.getProperty("line.separator") + "<!ELEMENT summaryresult EMPTY>" + System.getProperty("line.separator") + "<!ATTLIST summaryresult date CDATA #REQUIRED" + System.getProperty("line.separator") + "   statvalue CDATA #REQUIRED" + System.getProperty("line.separator") + "   filecount CDATA #REQUIRED" + System.getProperty("line.separator") + "   type CDATA #REQUIRED>" + System.getProperty("line.separator") + "]>" + System.getProperty("line.separator");
    private static final String EMPTY_FILE = DTD_DEFINITION + System.getProperty("line.separator") + "<qalab version=\"" + "1.1" + "\">" + "   <summary/>" + "</qalab>";
    private String currentXmlVersion = null;
    private Document compiledStats = null;
    private TaskLogger taskLogger = null;
    private boolean quiet = true;
    private File outputFile = null;
    private String action = "replace";
    private String timestampToUse = null;
    private String typeToUse = null;

    public final void configure(Properties properties) {
        InputStream stream = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            stream = this.parseOriginalDocument(properties, factory);
            this.validateXmlVersion(this.compiledStats);
            if (!this.quiet) {
                this.getTaskLogger().log("Parsed Statistics.");
            }
            this.loadActionAndStamp(properties);
            if ("replace".equals(this.action)) {
                this.clearAll(this.timestampToUse, this.typeToUse);
                if (!this.quiet) {
                    this.getTaskLogger().log("Finished clearing due to " + this.action);
                }
            }
        }
        catch (IOException e) {
            throw new BuildException("Cannot create file ", (Throwable)e);
        }
        catch (SAXException e) {
            throw new BuildException("Cannot parse file ", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Cannot find class ", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new BuildException("Issue with ParserConfiguration ", (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new BuildException("Cannot close streams", (Throwable)e);
                }
            }
            if (!this.quiet) {
                this.getTaskLogger().log("Finished Configuring XML streams.");
            }
        }
    }

    private void loadActionAndStamp(Properties properties) {
        String actionToUse = properties.getProperty("qalab.merge.action");
        if (actionToUse != null) {
            this.action = actionToUse.toLowerCase(Locale.ENGLISH);
        }
        if (!this.quiet) {
            this.getTaskLogger().log("ACTION: " + this.action);
        }
        this.timestampToUse = properties.getProperty("qalab.merge.output.timestamp");
        if (!this.quiet) {
            this.getTaskLogger().log("Timestamp to use:" + this.timestampToUse);
        }
        this.typeToUse = properties.getProperty("qalab.merge.type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream parseOriginalDocument(Properties properties, DocumentBuilderFactory factory) throws IOException, ClassNotFoundException, SAXException, ParserConfigurationException {
        InputStream stream;
        String file = properties.getProperty("qalab.merge.output.file");
        if (file != null) {
            this.outputFile = new File(file);
            if (!this.quiet) {
                this.getTaskLogger().log("Parsing " + this.outputFile);
            }
            if (!this.outputFile.exists()) {
                if (this.outputFile.createNewFile()) {
                    FileWriter stringOut = null;
                    try {
                        stringOut = new FileWriter(this.outputFile);
                        stringOut.write(EMPTY_FILE);
                        stringOut.flush();
                    }
                    finally {
                        if (stringOut != null) {
                            stringOut.close();
                        }
                    }
                } else {
                    throw new BuildException("Cannot create file " + this.outputFile.getAbsolutePath());
                }
            }
            if (!this.quiet) {
                this.getTaskLogger().log("Output file: " + this.outputFile.getAbsolutePath());
            }
            stream = new FileInputStream(this.outputFile);
        } else {
            String resourceName = properties.getProperty("qalab.merge.output.resourcename");
            String className = properties.getProperty("qalab.merge.output.classname");
            if (!this.quiet) {
                this.getTaskLogger().log("Using Stream: " + resourceName + " for " + className);
            }
            stream = Class.forName(className).getResourceAsStream(resourceName);
        }
        this.compiledStats = factory.newDocumentBuilder().parse(new InputSource(stream));
        return stream;
    }

    private void validateXmlVersion(Document doc) {
        Element qalab = this.getElement(doc.getElementsByTagName("qalab"));
        if (qalab != null) {
            this.currentXmlVersion = qalab.getAttribute("version");
            if (this.currentXmlVersion == null || !this.currentXmlVersion.equals(XML_VERSION)) {
                this.getTaskLogger().log("Inadequate DTD, must change it to 1.1");
                qalab.setAttribute("version", XML_VERSION);
                this.changeXmlToDtdV11(qalab);
            }
        }
    }

    private void changeXmlToDtdV11(Element qalab) {
        NodeList list = qalab.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            if (childNode.getNodeType() != 1) continue;
            if ("file".equals(childNode.getNodeName())) {
                Element fileNode = (Element)list.item(i);
                String id = fileNode.getAttribute("id");
                fileNode.setAttribute("id", id.replace('/', '_'));
                fileNode.setAttribute("path", id);
                NodeList results = fileNode.getChildNodes();
                for (int u = 0; u < results.getLength(); ++u) {
                    Node resultNode = results.item(u);
                    if (resultNode.getNodeType() != 1 || !"result".equals(resultNode.getNodeName())) continue;
                    Element resultElement = (Element)resultNode;
                    String timestamp = resultElement.getAttribute("date");
                    this.dropMidnight(resultElement, timestamp);
                }
                continue;
            }
            if (!"summary".equals(childNode.getNodeName())) continue;
            Element summaryNode = (Element)list.item(i);
            NodeList results = summaryNode.getChildNodes();
            for (int u = 0; u < results.getLength(); ++u) {
                Node resultNode = results.item(u);
                if (resultNode.getNodeType() != 1 || !"summaryresult".equals(resultNode.getNodeName())) continue;
                Element resultElement = (Element)resultNode;
                String timestamp = resultElement.getAttribute("date");
                this.dropMidnight(resultElement, timestamp);
            }
        }
    }

    private void dropMidnight(Element resultElement, String timestamp) {
        int indexOf = timestamp.indexOf(" 00:00:00");
        if (indexOf > 0) {
            resultElement.setAttribute("date", timestamp.substring(0, indexOf));
        }
    }

    public final void addSummary(int violationCount, int fileCount) {
        NodeList list = this.compiledStats.getElementsByTagName("summary");
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element summary = (Element)childNode;
            Element foundSummaryResult = summary.getOwnerDocument().createElement("summaryresult");
            foundSummaryResult.setAttribute("type", this.typeToUse);
            foundSummaryResult.setAttribute("filecount", "" + fileCount);
            foundSummaryResult.setAttribute("statvalue", "" + violationCount);
            foundSummaryResult.setAttribute("date", this.timestampToUse);
            summary.appendChild(foundSummaryResult);
            if (this.isQuiet()) break;
            this.getTaskLogger().log("Summary:" + this.typeToUse + " file:" + fileCount + " issues:" + violationCount);
            break;
        }
    }

    public final void addFileResult(int violationCount, String fileName) {
        String id = fileName.replace('/', '_');
        Element fileElement = this.compiledStats.getElementById(id);
        if (!this.isQuiet()) {
            this.taskLogger.log("* addNewResults for [" + fileName + "] Element:" + id);
        }
        if (fileElement == null) {
            if (!this.isQuiet()) {
                this.taskLogger.log("Create file new ENTRY......");
            }
            fileElement = this.compiledStats.createElement("file");
            fileElement.setAttribute("id", id);
            fileElement.setAttribute("path", fileName);
            this.compiledStats.getDocumentElement().appendChild(fileElement);
        }
        Element newResult = this.compiledStats.createElement("result");
        newResult.setAttribute("type", this.typeToUse);
        newResult.setAttribute("statvalue", "" + violationCount);
        newResult.setAttribute("date", this.timestampToUse);
        fileElement.appendChild(newResult);
    }

    private Element findSameTypeAndTimestamp(Element startingElement, String timestampStr, String type) {
        Element newResult = null;
        NodeList fileResults = startingElement.getChildNodes();
        if ("replace".equals(this.action)) {
            for (int u = 0; u < fileResults.getLength() && newResult == null; ++u) {
                Node resultNode = fileResults.item(u);
                if (resultNode.getNodeType() != 1) continue;
                String stamp = Util.getAttributeValue(resultNode.getAttributes(), "date", this.isQuiet(), this.getTaskLogger());
                String existingType = Util.getAttributeValue(resultNode.getAttributes(), "type", this.isQuiet(), this.getTaskLogger());
                if (!timestampStr.equals(stamp) || !type.equals(existingType)) continue;
                newResult = (Element)resultNode;
            }
        }
        return newResult;
    }

    public final void save() throws IOException {
        OutputFormat format = new OutputFormat(this.compiledStats, "UTF-8", true);
        FileWriter stringOut = new FileWriter(this.outputFile);
        if (!XML_VERSION.equals(this.currentXmlVersion)) {
            StringWriter sw = new StringWriter();
            XMLSerializer serial = new XMLSerializer((Writer)sw, format);
            serial.asDOMSerializer();
            serial.serialize(this.compiledStats);
            sw.flush();
            sw.close();
            StringBuffer newXml = new StringBuffer(sw.getBuffer().substring(sw.getBuffer().indexOf("<qalab")));
            newXml.insert(0, DTD_DEFINITION);
            stringOut.write(newXml.toString());
        } else {
            XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
            serial.asDOMSerializer();
            serial.serialize(this.compiledStats);
        }
        stringOut.flush();
        stringOut.close();
    }

    protected final TaskLogger getTaskLogger() {
        return this.taskLogger;
    }

    public final void setTaskLogger(TaskLogger task) {
        this.taskLogger = task;
    }

    public final boolean isQuiet() {
        return this.quiet;
    }

    public final void setQuiet(boolean noLog) {
        this.quiet = noLog;
    }

    public final Document getDocument() {
        return this.compiledStats;
    }

    private void clearAll(String timestampStr, String type) {
        NodeList list = this.compiledStats.getElementsByTagName("summary");
        this.clearChildren(list, timestampStr, type);
        NodeList listFiles = this.compiledStats.getElementsByTagName("file");
        this.clearChildren(listFiles, timestampStr, type);
    }

    private void clearChildren(NodeList list, String timestampStr, String type) {
        for (int i = 0; i < list.getLength(); ++i) {
            Element summary;
            Element foundSummaryResult;
            Node childNode = list.item(i);
            if (childNode.getNodeType() != 1 || (foundSummaryResult = this.findSameTypeAndTimestamp(summary = (Element)childNode, timestampStr, type)) == null) continue;
            if (!this.isQuiet()) {
                this.getTaskLogger().log("Removing element due to same type and timestamp " + foundSummaryResult.getNodeName());
            }
            childNode.removeChild(foundSummaryResult);
        }
    }

    private Element getElement(NodeList list) {
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            if (childNode.getNodeType() != 1) continue;
            return (Element)childNode;
        }
        return null;
    }
}

