/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class StackedBarChartDemo6
extends ApplicationFrame {
    public StackedBarChartDemo6(String string) {
        super(string);
        JPanel jPanel = StackedBarChartDemo6.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        long l = 86400000L;
        defaultCategoryDataset.addValue(3L * l, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(1L * l, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(2L * l, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(4L * l, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(5L * l, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(1L * l, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 2"));
        return defaultCategoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart("Stacked Bar Chart Demo 6", "Category", "Value", categoryDataset, PlotOrientation.HORIZONTAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setRangeGridlinePaint(Color.white);
        StackedBarRenderer stackedBarRenderer = (StackedBarRenderer)categoryPlot.getRenderer();
        stackedBarRenderer.setDrawBarOutline(false);
        long l = System.currentTimeMillis();
        stackedBarRenderer.setBase(l);
        DateAxis dateAxis = new DateAxis("Date");
        dateAxis.setLowerMargin(0.0);
        categoryPlot.setRangeAxis(dateAxis);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = StackedBarChartDemo6.createChart(StackedBarChartDemo6.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        StackedBarChartDemo6 stackedBarChartDemo6 = new StackedBarChartDemo6("Stacked Bar Chart Demo 6");
        stackedBarChartDemo6.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)stackedBarChartDemo6));
        stackedBarChartDemo6.setVisible(true);
    }
}

