/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Dimension;
import java.awt.Window;
import java.io.IOException;
import java.util.Random;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class HistogramDemo1
extends ApplicationFrame {
    public HistogramDemo1(String string) {
        super(string);
        JPanel jPanel = HistogramDemo1.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static IntervalXYDataset createDataset() {
        int n;
        HistogramDataset histogramDataset = new HistogramDataset();
        double[] dArray = new double[1000];
        Random random = new Random(12345678L);
        for (n = 0; n < 1000; ++n) {
            dArray[n] = random.nextGaussian() + 5.0;
        }
        histogramDataset.addSeries((Comparable)((Object)"H1"), dArray, 100, 2.0, 8.0);
        dArray = new double[1000];
        for (n = 0; n < 1000; ++n) {
            dArray[n] = random.nextGaussian() + 7.0;
        }
        histogramDataset.addSeries((Comparable)((Object)"H2"), dArray, 100, 4.0, 10.0);
        return histogramDataset;
    }

    private static JFreeChart createChart(IntervalXYDataset intervalXYDataset) {
        JFreeChart jFreeChart = ChartFactory.createHistogram("Histogram Demo", null, null, intervalXYDataset, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setForegroundAlpha(0.85f);
        XYBarRenderer xYBarRenderer = (XYBarRenderer)xYPlot.getRenderer();
        xYBarRenderer.setDrawBarOutline(false);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = HistogramDemo1.createChart(HistogramDemo1.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) throws IOException {
        HistogramDemo1 histogramDemo1 = new HistogramDemo1("Histogram Demo 1");
        histogramDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)histogramDemo1));
        histogramDemo1.setVisible(true);
    }
}

