/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryStepRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class CategoryStepChartDemo1
extends ApplicationFrame {
    public CategoryStepChartDemo1(String string) {
        super(string);
        CategoryDataset categoryDataset = CategoryStepChartDemo1.createDataset();
        JFreeChart jFreeChart = CategoryStepChartDemo1.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setEnforceFileExtensions(false);
        this.setContentPane(chartPanel);
    }

    private static CategoryDataset createDataset() {
        double[][] dArrayArray = new double[][]{{1.0, 4.0, 3.0, 5.0, 5.0, 7.0, 7.0, 8.0}, {5.0, 7.0, 6.0, 8.0, 4.0, 4.0, 2.0, 1.0}, {4.0, 3.0, 2.0, 3.0, 6.0, 3.0, 4.0, 3.0}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("Series ", "Type ", (double[][])dArrayArray);
        return categoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        CategoryStepRenderer categoryStepRenderer = new CategoryStepRenderer(true);
        categoryStepRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        CategoryAxis categoryAxis = new CategoryAxis("Category");
        NumberAxis numberAxis = new NumberAxis("Value");
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, categoryStepRenderer);
        JFreeChart jFreeChart = new JFreeChart("Category Step Chart", categoryPlot);
        jFreeChart.setBackgroundPaint(Color.white);
        categoryPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setDomainGridlinesVisible(true);
        categoryPlot.setDomainGridlinePaint(Color.white);
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setRangeGridlinePaint(Color.white);
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        categoryAxis.setLowerMargin(0.0);
        categoryAxis.setUpperMargin(0.0);
        categoryAxis.addCategoryLabelToolTip((Comparable)((Object)"Type 1"), "The first type.");
        categoryAxis.addCategoryLabelToolTip((Comparable)((Object)"Type 2"), "The second type.");
        categoryAxis.addCategoryLabelToolTip((Comparable)((Object)"Type 3"), "The third type.");
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setLabelAngle(0.0);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = CategoryStepChartDemo1.createChart(CategoryStepChartDemo1.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        CategoryStepChartDemo1 categoryStepChartDemo1 = new CategoryStepChartDemo1("JFreeChart : CategoryStepChartDemo1");
        categoryStepChartDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)categoryStepChartDemo1));
        categoryStepChartDemo1.setVisible(true);
    }
}

