/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.experimental.data.xy.VectorDataItem;
import org.jfree.experimental.data.xy.VectorSeries;
import org.jfree.experimental.data.xy.VectorXYDataset;
import org.jfree.util.ObjectUtilities;

public class VectorSeriesCollection
extends AbstractXYDataset
implements VectorXYDataset,
Serializable {
    private List data = new ArrayList();

    public void addSeries(VectorSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(series);
        series.addChangeListener((SeriesChangeListener)this);
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public VectorSeries getSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (VectorSeries)((Object)this.data.get(series));
    }

    public Comparable getSeriesKey(int series) {
        return this.getSeries(series).getKey();
    }

    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    public double getXValue(int series, int item) {
        VectorSeries s = (VectorSeries)((Object)this.data.get(series));
        VectorDataItem di = (VectorDataItem)s.getDataItem(item);
        return di.getXValue();
    }

    public Number getX(int series, int item) {
        return new Double(this.getXValue(series, item));
    }

    public double getYValue(int series, int item) {
        VectorSeries s = (VectorSeries)((Object)this.data.get(series));
        VectorDataItem di = (VectorDataItem)s.getDataItem(item);
        return di.getYValue();
    }

    public Number getY(int series, int item) {
        return new Double(this.getYValue(series, item));
    }

    public Number getDeltaX(int series, int item) {
        return new Double(this.getDeltaXValue(series, item));
    }

    public double getDeltaXValue(int series, int item) {
        VectorSeries s = (VectorSeries)((Object)this.data.get(series));
        VectorDataItem di = (VectorDataItem)s.getDataItem(item);
        return di.getDeltaX();
    }

    public Number getDeltaY(int series, int item) {
        return new Double(this.getDeltaYValue(series, item));
    }

    public double getDeltaYValue(int series, int item) {
        VectorSeries s = (VectorSeries)((Object)this.data.get(series));
        VectorDataItem di = (VectorDataItem)s.getDataItem(item);
        return di.getDeltaY();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VectorSeriesCollection)) {
            return false;
        }
        VectorSeriesCollection that = (VectorSeriesCollection)obj;
        return ObjectUtilities.equal((Object)this.data, (Object)that.data);
    }

    public Object clone() throws CloneNotSupportedException {
        VectorSeriesCollection clone = (VectorSeriesCollection)super.clone();
        clone.data = (List)ObjectUtilities.deepClone((Collection)this.data);
        return clone;
    }
}

